/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.updates;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.updates.UpdateCollection;
import com.ibm.hwmca.xfw.updates.UpdateLevel;
import com.ibm.hwmca.xfw.updates.UpdateManager;
import com.ibm.hwmca.xfw.updates.UpdateableComponent;
import com.ibm.hwmca.xfw.updates.UpdaterEvent;
import com.ibm.hwmca.xfw.updates.UpdaterListener;
import com.ibm.hwmca.xfw.updates.UpdatesOwner;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public abstract class Updater {
    private static final String TRACE_MASKT = "XCM XURT";
    private static final String TRACE_MASKF = "XCM XURF";
    UpdatesOwner owner;
    ArrayList updateListeners = new ArrayList(1);
    Object listenerLock = new Object();
    MessageText lastMessage;
    MessageText lastDetailsMessage;
    Object attachment;

    protected Updater(UpdatesOwner owner) {
        this.owner = owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUpdaterListener(UpdaterListener listener) {
        Object object = this.listenerLock;
        synchronized (object) {
            this.updateListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUpdaterListener(UpdaterListener listener) {
        Object object = this.listenerLock;
        synchronized (object) {
            this.updateListeners.remove(listener);
        }
    }

    public UpdatesOwner getOwner() {
        return this.owner;
    }

    private List getLevelsForAllComponents() throws HException {
        List components = this.owner.getUpdateableComponents();
        ArrayList<UpdateLevel> levels = new ArrayList<UpdateLevel>(components.size());
        Iterator iterator = components.iterator();
        while (iterator.hasNext()) {
            Object component = iterator.next();
            if (!(component instanceof UpdateableComponent)) continue;
            UpdateLevel level = new UpdateLevel(((UpdateableComponent)component).getECNumber(), -1);
            levels.add(level);
        }
        return levels;
    }

    public void applyAllStaged() throws HException {
        this.applyAllStaged(true);
    }

    public void applyAllStaged(boolean disruptionAllowed) throws HException {
        Trace.trace(TRACE_MASKT, "<> applyAllStaged()");
        Thread thread = new Thread(new Runnable(){

            public void run() {
                Updater.this.applyAllStagedSynchronously();
            }
        }, "Asynchronous applyAllStaged operation");
        thread.start();
    }

    private void applyAllStagedSynchronously() {
        Trace.trace(TRACE_MASKT, "-> applyAllStagedSynchronously()");
        try {
            List steps = UpdateManager.getUpdateManager().arrangeDependenciesForApply(this.getLevelsForAllComponents());
            if (steps.size() == 0) {
                UpdaterEvent event = new UpdaterEvent(this);
                event.setCompletionStatus(1);
                this.fireOperationCompleted(event);
                return;
            }
            UpdaterEvent event = new UpdaterEvent(this);
            List firstStep = (List)steps.get(0);
            Iterator iterator = firstStep.iterator();
            while (iterator.hasNext()) {
                UpdateCollection collection = (UpdateCollection)iterator.next();
                try {
                    Trace.trace(TRACE_MASKF, "Applying collection: " + collection);
                    collection.apply();
                    event.setMessage(collection.getLastMessage());
                    event.setDetailsMessage(collection.getLastDetailsMessage());
                    if (iterator.hasNext()) {
                        this.fireOperationProgressing(event);
                        continue;
                    }
                    event.setCompletionStatus(steps.size() > 1 ? 4 : 1);
                    this.fireOperationCompleted(event);
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "Exception from UpdateCollection.apply()");
                    Trace.trace(TRACE_MASKF, e);
                    event.setCompletionStatus(2);
                    event.setMessage(collection.getLastMessage());
                    event.setDetailsMessage(collection.getLastDetailsMessage());
                    this.fireOperationCompleted(event);
                    return;
                }
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Unexpected exception");
            Trace.trace(TRACE_MASKF, e);
            UpdaterEvent event = new UpdaterEvent(this);
            event.setCompletionStatus(2);
            this.fireOperationCompleted(event);
        }
    }

    public void rejectAllApplied() throws HException {
        this.rejectAllApplied(true);
    }

    public void rejectAllApplied(boolean disruptionAllowed) throws HException {
        Trace.trace(TRACE_MASKT, "<> rejectAllApplied()");
        Thread thread = new Thread(new Runnable(){

            public void run() {
                Updater.this.rejectAllAppliedSynchronously();
            }
        }, "Asynchronous rejectAllApplied operation");
        thread.start();
    }

    private void rejectAllAppliedSynchronously() {
        Trace.trace(TRACE_MASKT, "-> rejectAllAppliedSynchronously()");
        try {
            List steps = UpdateManager.getUpdateManager().arrangeDependenciesForReject(this.getLevelsForAllComponents());
            if (steps.size() == 0) {
                UpdaterEvent event = new UpdaterEvent(this);
                event.setCompletionStatus(1);
                this.fireOperationCompleted(event);
                return;
            }
            UpdaterEvent event = new UpdaterEvent(this);
            List firstStep = (List)steps.get(0);
            Iterator iterator = firstStep.iterator();
            while (iterator.hasNext()) {
                UpdateCollection collection = (UpdateCollection)iterator.next();
                try {
                    Trace.trace(TRACE_MASKF, "Rejecting collection: " + collection);
                    collection.reject();
                    event.setMessage(collection.getLastMessage());
                    event.setDetailsMessage(collection.getLastDetailsMessage());
                    if (iterator.hasNext()) {
                        this.fireOperationProgressing(event);
                        continue;
                    }
                    event.setCompletionStatus(steps.size() > 1 ? 4 : 1);
                    this.fireOperationCompleted(event);
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "Exception from UpdateCollection.reject()");
                    Trace.trace(TRACE_MASKF, e);
                    event.setCompletionStatus(2);
                    event.setMessage(collection.getLastMessage());
                    event.setDetailsMessage(collection.getLastDetailsMessage());
                    this.fireOperationCompleted(event);
                    return;
                }
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Unexpected exception");
            Trace.trace(TRACE_MASKF, e);
            UpdaterEvent event = new UpdaterEvent(this);
            event.setCompletionStatus(2);
            this.fireOperationCompleted(event);
        }
    }

    public void commitAllApplied(boolean disruptionAllowed) throws HException {
        Trace.trace(TRACE_MASKT, "<> commitAllApplied()");
        Thread thread = new Thread(new Runnable(){

            public void run() {
                Updater.this.commitAllAppliedSynchronously();
            }
        }, "Asynchronous commitAllApplied operation");
        thread.start();
    }

    private void commitAllAppliedSynchronously() {
        Trace.trace(TRACE_MASKT, "-> commitAllAppliedSynchronously()");
        try {
            List step = UpdateManager.getUpdateManager().arrangeDependenciesForCommit(this.getLevelsForAllComponents());
            if (step.size() == 0) {
                UpdaterEvent event = new UpdaterEvent(this);
                event.setCompletionStatus(1);
                this.fireOperationCompleted(event);
                return;
            }
            UpdaterEvent event = new UpdaterEvent(this);
            Iterator iterator = step.iterator();
            while (iterator.hasNext()) {
                UpdateCollection collection = (UpdateCollection)iterator.next();
                try {
                    Trace.trace(TRACE_MASKF, "Committing collection: " + collection);
                    collection.commit();
                    event.setMessage(collection.getLastMessage());
                    event.setDetailsMessage(collection.getLastDetailsMessage());
                    if (iterator.hasNext()) {
                        this.fireOperationProgressing(event);
                        continue;
                    }
                    event.setCompletionStatus(1);
                    this.fireOperationCompleted(event);
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "Exception from UpdateCollection.commit()");
                    Trace.trace(TRACE_MASKF, e);
                    event.setCompletionStatus(2);
                    event.setMessage(collection.getLastMessage());
                    event.setDetailsMessage(collection.getLastDetailsMessage());
                    this.fireOperationCompleted(event);
                    return;
                }
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Unexpected exception");
            Trace.trace(TRACE_MASKF, e);
            UpdaterEvent event = new UpdaterEvent(this);
            event.setCompletionStatus(2);
            this.fireOperationCompleted(event);
        }
    }

    public void deleteAllStaged() throws HException {
        Trace.trace(TRACE_MASKT, "<> deleteAllStaged()");
        Thread thread = new Thread(new Runnable(){

            public void run() {
                Updater.this.deleteAllStagedSynchronously();
            }
        }, "Asynchronous deleteAllStaged operation");
        thread.start();
    }

    private void deleteAllStagedSynchronously() {
        Trace.trace(TRACE_MASKT, "-> deleteAllStagedSynchronously()");
        try {
            List components = this.owner.getUpdateableComponents();
            boolean gaveCompletion = false;
            UpdaterEvent event = new UpdaterEvent(this);
            Iterator iterator = components.iterator();
            while (iterator.hasNext()) {
                Object aComponent = iterator.next();
                if (!(aComponent instanceof UpdateableComponent)) continue;
                UpdateableComponent component = (UpdateableComponent)aComponent;
                List collections = component.getUpdateCollections();
                Iterator collIterator = collections.iterator();
                while (collIterator.hasNext()) {
                    UpdateCollection collection = (UpdateCollection)collIterator.next();
                    try {
                        if (collection.getState() != 1) continue;
                        Trace.trace(TRACE_MASKF, "Deleting collection: " + collection);
                        collection.delete();
                        event.setMessage(collection.getLastMessage());
                        event.setDetailsMessage(collection.getLastDetailsMessage());
                        if (iterator.hasNext()) {
                            this.fireOperationProgressing(event);
                            continue;
                        }
                        event.setCompletionStatus(1);
                        this.fireOperationCompleted(event);
                        gaveCompletion = true;
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKF, "Exception from UpdateCollection.delete()");
                        Trace.trace(TRACE_MASKF, e);
                        event.setCompletionStatus(2);
                        event.setMessage(collection.getLastMessage());
                        event.setDetailsMessage(collection.getLastDetailsMessage());
                        this.fireOperationCompleted(event);
                        return;
                    }
                }
            }
            if (!gaveCompletion) {
                event.setCompletionStatus(1);
                this.fireOperationCompleted(event);
                return;
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Unexpected exception");
            Trace.trace(TRACE_MASKF, e);
            UpdaterEvent event = new UpdaterEvent(this);
            event.setCompletionStatus(2);
            this.fireOperationCompleted(event);
        }
    }

    public abstract void importAllRemoteUnstagedUpdates(boolean var1);

    public abstract void importRemoteUpdatesThroughLevel(Collection var1, boolean var2);

    public abstract Collection listAllUnstagedUpdateFilesOnMedia(File var1, int var2);

    public abstract void importAllUnstagedUpdatesFromMedia(File var1, int var2);

    public abstract Collection listUpdateFilesThroughLevelOnMedia(File var1, int var2, Collection var3);

    public abstract void importUpdatesThroughLevelFromMedia(File var1, int var2, Collection var3);

    public abstract void exportUpdatesToMedia(File var1, int var2, Collection var3);

    public abstract boolean isMediaApplicable(File var1, int var2);

    public abstract Collection getLatestUpdateLevelsFromMedia(File var1, int var2, Collection var3);

    public abstract void cancel();

    public synchronized MessageText getLastMessage() {
        MessageText message = this.lastMessage;
        this.lastMessage = null;
        return message;
    }

    protected synchronized void setLastMessage(MessageText message) {
        this.lastMessage = message;
    }

    public synchronized MessageText getLastDetailsMessage() {
        MessageText message = this.lastDetailsMessage;
        this.lastDetailsMessage = null;
        return message;
    }

    protected synchronized void setLastDetailsMessage(MessageText message) {
        this.lastDetailsMessage = message;
    }

    public Object getAttachment() {
        return this.attachment;
    }

    public void setAttachment(Object attachment) {
        this.attachment = attachment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireOperationProgressing(UpdaterEvent event) {
        Object object = this.listenerLock;
        synchronized (object) {
            Trace.trace(TRACE_MASKF, "Firing Updater operation progressing");
            List listeners = (List)this.updateListeners.clone();
            Iterator iterator = listeners.iterator();
            while (iterator.hasNext()) {
                UpdaterListener listener = (UpdaterListener)iterator.next();
                listener.operationProgressing(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireOperationCompleted(UpdaterEvent event) {
        Object object = this.listenerLock;
        synchronized (object) {
            Trace.trace(TRACE_MASKF, "Firing Updater operation completed; status == " + event.getCompletionStatus());
            List listeners = (List)this.updateListeners.clone();
            Iterator iterator = listeners.iterator();
            while (iterator.hasNext()) {
                UpdaterListener listener = (UpdaterListener)iterator.next();
                listener.operationCompleted(event);
            }
        }
    }
}

